/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.domdebugger.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v118.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v118.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v118.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class EventListener {
    private final String type;
    private final Boolean useCapture;
    private final Boolean passive;
    private final Boolean once;
    private final ScriptId scriptId;
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final Optional<RemoteObject> handler;
    private final Optional<RemoteObject> originalHandler;
    private final Optional<BackendNodeId> backendNodeId;

    public EventListener(String type, Boolean useCapture, Boolean passive, Boolean once, ScriptId scriptId, Integer lineNumber, Integer columnNumber, Optional<RemoteObject> handler, Optional<RemoteObject> originalHandler, Optional<BackendNodeId> backendNodeId) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.useCapture = Objects.requireNonNull(useCapture, "useCapture is required");
        this.passive = Objects.requireNonNull(passive, "passive is required");
        this.once = Objects.requireNonNull(once, "once is required");
        this.scriptId = Objects.requireNonNull(scriptId, "scriptId is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
        this.handler = handler;
        this.originalHandler = originalHandler;
        this.backendNodeId = backendNodeId;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getUseCapture() {
        return this.useCapture;
    }

    public Boolean getPassive() {
        return this.passive;
    }

    public Boolean getOnce() {
        return this.once;
    }

    public ScriptId getScriptId() {
        return this.scriptId;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public Optional<RemoteObject> getHandler() {
        return this.handler;
    }

    public Optional<RemoteObject> getOriginalHandler() {
        return this.originalHandler;
    }

    public Optional<BackendNodeId> getBackendNodeId() {
        return this.backendNodeId;
    }

    private static EventListener fromJson(JsonInput input) {
        String type = null;
        Boolean useCapture = false;
        Boolean passive = false;
        Boolean once = false;
        ScriptId scriptId = null;
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        Optional<RemoteObject> handler = Optional.empty();
        Optional<RemoteObject> originalHandler = Optional.empty();
        Optional<BackendNodeId> backendNodeId = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = input.nextString();
                    continue block24;
                }
                case "useCapture": {
                    useCapture = input.nextBoolean();
                    continue block24;
                }
                case "passive": {
                    passive = input.nextBoolean();
                    continue block24;
                }
                case "once": {
                    once = input.nextBoolean();
                    continue block24;
                }
                case "scriptId": {
                    scriptId = (ScriptId)input.read(ScriptId.class);
                    continue block24;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block24;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block24;
                }
                case "handler": {
                    handler = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block24;
                }
                case "originalHandler": {
                    originalHandler = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block24;
                }
                case "backendNodeId": {
                    backendNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new EventListener(type, useCapture, passive, once, scriptId, lineNumber, columnNumber, handler, originalHandler, backendNodeId);
    }
}

